*Compute poverty rates in 2011 and test significance of difference
***use linear regression and suest to compute significance of difference

*Tim Goedemé

global place1 ...\EU-SILC\Cross\2020-04\
global place2 ...\social class and poverty\StataOutput\
global countries AT BE BG CH CY CZ DE DK EE EL ES FI FR HR HU IE IS IT LT LU LV MT NL NO PL PT RO RS SE SI SK UK

*******************************************
*9 - Class structure * Difference in 2011 *
*******************************************

set matsize 5000
global countries AT BE CH CY CZ DE DK EE EL ES FR HR HU IS IT LT LU LV MT NL NO PL PT RO SE SI SK UK

cap mat drop results1
cap mat drop results2

foreach ctry of global countries {
	di "`ctry'", _continue
	
	quietly {
		cap mat drop tempmat1
		cap mat drop tempmat2
		
		local year=2011
		use "${place1}\`ctry'\\`year'\c`ctry'`year'_analysis.dta", clear
		
		gen sub = (resp==1 & active==1 & actage==1)
		replace sub=0 if esec08==. | esec88==.
		
		svyset psu1 [pw=rb050], strata(strata1)
		svy, subpop(if sub==1): regress arop60 i.esec88
		estimates store est1
		svy, subpop(if sub==1): regress arop60 i.esec08
		estimates store est2
		suest est1 est2, svy
		
		forvalues x=1/2 {
			lincom _b[est`x':_cons]
			mat def tempmat1 = nullmat(tempmat1) \ `x', 1, r(estimate), r(se), r(lb), r(ub), r(df)
		}
					
		lincom _b[est2:_cons] - _b[est1:_cons]
		mat def tempmat2 = nullmat(tempmat2) \ 1, r(estimate), r(se), r(lb), r(ub), r(df)
		
		forvalues c=2(1)9 {
		
			lincom _b[est1:_cons] + _b[est1:`c'.esec88]
			mat def tempmat1 = nullmat(tempmat1) \ 1, `c', r(estimate), r(se), r(lb), r(ub), r(df)
			lincom _b[est2:_cons] + _b[est2:`c'.esec08]
			mat def tempmat1 = nullmat(tempmat1) \ 2, `c', r(estimate), r(se), r(lb), r(ub), r(df)

			lincom (_b[est2:_cons] + _b[est2:`c'.esec08]) - (_b[est1:_cons] + _b[est1:`c'.esec88])
			mat def tempmat2 = nullmat(tempmat2) \ `c', r(estimate), r(se), r(lb), r(ub), r(df)
		}
		mat rownames tempmat1 = `ctry'
		mat rownames tempmat2 = `ctry'
	}
	mat def results1 = nullmat(results1) \ tempmat1
	mat def results2 = nullmat(results2) \ tempmat2
}
mat colnames results1 = esec class est se lb ub df
mat colnames results2  = class est se lb ub df
mat li results1
mat li results2


**********************
*5 - Class structure *
**********************

global countries AT BE CH CY CZ DE DK EE EL ES FR HR HU IS IT LT LU LV MT NL NO PL PT RO SE SI SK UK

cap mat drop results1
cap mat drop results2

foreach ctry of global countries {
	di "`ctry'", _continue
	
	quietly {
		cap mat drop tempmat1
		cap mat drop tempmat2
		
		local year=2011
		use "${place1}\`ctry'\\`year'\c`ctry'`year'_analysis.dta", clear
		
		gen sub = (resp==1 & active==1 & actage==1)
		replace sub=0 if esec08==. | esec88==.
		
		local varlist esec88 esec08
		foreach v of local varlist {
			qui: replace `v' = 12 if `v'==1 | `v'==2
			qui: replace `v' = 36 if `v'==3 | `v'==6
			qui: replace `v' = 45 if `v'==4 | `v'==5
			qui: replace `v' = 70 if `v'==7
			qui: replace `v' = 89 if `v'==8 | `v'==9
		}
		
		svyset psu1 [pw=rb050], strata(strata1)
		svy, subpop(if sub==1): regress arop60 i.esec88
		estimates store est1
		svy, subpop(if sub==1): regress arop60 i.esec08
		estimates store est2
		suest est1 est2, svy
		
		local cats 12 36 45 70 89
		foreach c of local cats {
		
			lincom _b[est1:_cons] + _b[est1:`c'.esec88]
			mat def tempmat1 = nullmat(tempmat1) \ 1, `c', r(estimate), r(se), r(lb), r(ub), r(df)
			lincom _b[est2:_cons] + _b[est2:`c'.esec08]
			mat def tempmat1 = nullmat(tempmat1) \ 2, `c', r(estimate), r(se), r(lb), r(ub), r(df)

			lincom (_b[est2:_cons] + _b[est2:`c'.esec08]) - (_b[est1:_cons] + _b[est1:`c'.esec88])
			mat def tempmat2 = nullmat(tempmat2) \ `c', r(estimate), r(se), r(lb), r(ub), r(df)
		}
		mat rownames tempmat1 = `ctry'
		mat rownames tempmat2 = `ctry'
	}
	mat def results1 = nullmat(results1) \ tempmat1
	mat def results2 = nullmat(results2) \ tempmat2
}
mat colnames results1 = esec class est se lb ub df
mat colnames results2  = class est se lb ub df
mat li results1
mat li results2


*********************
* 3 class structure *
*********************


global countries AT BE CH CY CZ DE DK EE EL ES FR HR HU IS IT LT LU LV MT NL NO PL PT RO SE SI SK UK

cap mat drop results1
cap mat drop results2

foreach ctry of global countries {
	di "`ctry'", _continue
	
	quietly {
		cap mat drop tempmat1
		cap mat drop tempmat2
		
		local year=2011
		use "${place1}\`ctry'\\`year'\c`ctry'`year'_analysis.dta", clear
		
		gen sub = (resp==1 & active==1 & actage==1)
		replace sub=0 if esec08==. | esec88==.
		
		local varlist esec88 esec08
		foreach v of local varlist {
			qui: replace `v' = 12 if `v'==1 | `v'==2
			qui: replace `v' = 3456 if `v'==3 | `v'==6
			qui: replace `v' = 3456 if `v'==4 | `v'==5
			qui: replace `v' = 789 if `v'==7
			qui: replace `v' = 789 if `v'==8 | `v'==9
		}
		
		svyset psu1 [pw=rb050], strata(strata1)
		svy, subpop(if sub==1): regress arop60 i.esec88
		estimates store est1
		svy, subpop(if sub==1): regress arop60 i.esec08
		estimates store est2
		suest est1 est2, svy
		
		local cats 12 3456 789
		foreach c of local cats {
		
			lincom _b[est1:_cons] + _b[est1:`c'.esec88]
			mat def tempmat1 = nullmat(tempmat1) \ 1, `c', r(estimate), r(se), r(lb), r(ub), r(df)
			lincom _b[est2:_cons] + _b[est2:`c'.esec08]
			mat def tempmat1 = nullmat(tempmat1) \ 2, `c', r(estimate), r(se), r(lb), r(ub), r(df)

			lincom (_b[est2:_cons] + _b[est2:`c'.esec08]) - (_b[est1:_cons] + _b[est1:`c'.esec88])
			mat def tempmat2 = nullmat(tempmat2) \ `c', r(estimate), r(se), r(lb), r(ub), r(df)
		}
		mat rownames tempmat1 = `ctry'
		mat rownames tempmat2 = `ctry'
	}
	mat def results1 = nullmat(results1) \ tempmat1
	mat def results2 = nullmat(results2) \ tempmat2
}
mat colnames results1 = esec class est se lb ub df
mat colnames results2  = class est se lb ub df
mat li results1
mat li results2
